Sets
        h       horas /H1*H48/

        i       ciudades
        /204,
         250,
         306,
         403,
         416,
         418,
         506,
         514,
         519,
         604,
         613,
         705,
         709,
         807,
         819,
         902,
         905
         /

        j       lugares para instalarse
        /204a,
         204b,
         514a,
         514b,
         514c,
         613,
         705,
         819a,
         819b,
         902
         /
;

alias(j,jj,l,kk);


Parameters
        c(j)    costo (por hora y por telefonista) en el lugar j y la hora h
        d(i)    Demanda anual del centro i
        P(h)    % de llamadas a la hora h
        F(j)    costo fijo de instalarse en j
;

$include "C:\Auxiliar 2\costosoper.inc"
$include "C:\Auxiliar 2\demanda.inc"
$include "C:\Auxiliar 2\probabilidad2.inc"
$include "C:\Auxiliar 2\costofijo.inc"
$include "C:\Auxiliar 2\diferencia2.inc"
$include "C:\Auxiliar 2\comunicacion.inc"


Variables
        z        funcion objetivo
        x(j)     si instalo o no el centro en el situo j
        y(j,h)   numero de telefonistas a poner en la central j en la hora h
        zz(i,j) porcentaje de la dda de i absorvida por j en la hora h
        w1(j)   numero de telefonistas en la central j en el turno 1
        w2(j)   numero de telefonistas en la central j en el turno 2
        w3(j)   numero de telefonistas en la central j en el turno 3
;

Binary variable x;
Integer variable y,w1,w2,w3;
Positive variable zz;


Equations
        FObj            funcion objetivo
        Logica(i,j)        no hay telefonistas en los lugares donde no se instalo centro
        Demanda(j,h)    que las llamadas recibidas sean menor o ms de las que las telefonistas pueden atender
        Porcent(i) que los pocentajes atrendidos en cada central sumen 1
        Turno1(j,h) turno 1 igual gente
        Turno2(j,h) turno 2 igual gente
        Turno3(j,h) turno 3 igual gente
        Sensibilidad   numero de centros
;

        FObj..
        z =e= sum(j,(F(j)*x(j)))+ sum(j,sum(h$((ord(h) ge 1) and (ord(h) le 10)),((c(j)/2)*365*1.5*y(j,h))))+ sum(j,sum(h$((ord(h) ge 11) and (ord(h) le 44)),((c(j)/2)*365*y(j,h))))+ sum(j,sum(h$((ord(h) ge 45) and (ord(h) le 48)),((c(j)/2)*365*1.5*y(j,h))))+sum((i,j),((k(i,j)/10.8)*d(i)*zz(i,j)));

        Logica(i,j)..
        x(j) =g= zz(i,j);

        Porcent(i)..
        1=e=sum(j,zz(i,j));

        Demanda(j,h)..
        5.4*y(j,h)=g=sum(i,((d(i)/365)*P(h++g(j,i)))*zz(i,j));

        Turno1(j,h)$((ord(h) ge 1) and (ord(h) le 14) or (ord(h) = 47) or (ord(h) = 48))..
        y(j,h)=e=w1(j);

        Turno2(j,h)$((ord(h) ge 15) and (ord(h) le 30))..
        y(j,h)=e=w2(j);

        Turno3(j,h)$((ord(h) ge 31) and (ord(h) le 46))..
        y(j,h)=e=w3(j);

        Sensibilidad..
        sum(j,x(j))=e=4;

Model Tarea /All/;

Solve Tarea using RMIP minimizing z;

parameter aux1,aux2,aux3,zmin, xfijo(j), w1fijo(j), w2fijo(j), w3fijo(j);

zmin=20000000;

loop (l,
         if (x.l(l) = 1, x.fx(l) = 1;);
);

loop (l,
         if (x.l(l) ne 1, x.fx(l) = 1;
                          loop(kk,
                                if (x.l(kk) ne 1, x.fx(kk)=0;);
                          );
                          Solve Tarea using RMIP minimizing z;
                          loop(kk,
                                if (x.l(kk) = 1,      aux1=ceil(w1.l(kk));
                                                      aux2=ceil(w2.l(kk));
                                                      aux3=ceil(w3.l(kk));
                                                      w1.fx(kk)=aux1;
                                                      w2.fx(kk)=aux2;
                                                      w3.fx(kk)=aux3;
                                );
                          );
                          Solve Tarea using RMIP minimizing z;
                          if (z.l<zmin,     zmin=z.l;
                                 loop(kk,
                                          xfijo(kk)=x.l(kk);
                                          w1fijo(kk)=w1.l(kk);
                                          w2fijo(kk)=w2.l(kk);
                                          w3fijo(kk)=w3.l(kk);
                                 );
                          );
                          loop (kk,
                               w1.lo(kk)=0;
                               w1.up(kk)=49;
                               w2.lo(kk)=0;
                               w2.up(kk)=49;
                               w3.lo(kk)=0;
                               w3.up(kk)=49;
                          );
                          w1.fx(l)=0;
                          w2.fx(l)=0;
                          w3.fx(l)=0;
                          x.fx(l)=0;
         );
);


display zmin, xfijo, w1fijo, w2fijo, w3fijo;